<?php

defined('ABSPATH') || exit;

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define server constants
if (!defined('CUSTOM_UPDATES_SERVER')) {
    define('CUSTOM_UPDATES_SERVER', 'https://gplcenter.com/updater/server.php?action=get_updates');
}

if (!defined('SUBSCRIPTION_CHECK_URL')) {
    define('SUBSCRIPTION_CHECK_URL', 'https://gplcenter.com/updater/server.php?action=verify_subscription');
}

if (!defined('CUSTOM_UPDATES_HEADER')) {
    define('CUSTOM_UPDATES_HEADER', 'YourSecretHeaderValue');
}

// هذه الدالة في بداية الكود لاستخراج المجال
function cum_get_normalized_domain() {
    $domain = get_site_url();
    $parsedUrl = parse_url($domain, PHP_URL_HOST);
    return preg_replace('/^www\./', '', strtolower($parsedUrl));
}

// Database functions
function cum_get_gpl_server_option($key, $default = '') {
    global $wpdb;
    $table_name = $wpdb->prefix . 'gpl_center_options';
    
    $result = $wpdb->get_var($wpdb->prepare(
        "SELECT option_value FROM $table_name WHERE option_name = %s",
        $key
    ));
    
    return $result !== null ? maybe_unserialize($result) : $default;
}

function cum_update_gpl_server_option($key, $value) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'gpl_center_options';
    
    $data = array(
        'option_name' => $key,
        'option_value' => maybe_serialize($value)
    );
    
    $format = array('%s', '%s');
    
    $existing = $wpdb->get_var($wpdb->prepare(
        "SELECT option_name FROM $table_name WHERE option_name = %s",
        $key
    ));
    
    if ($existing) {
        $wpdb->update($table_name, $data, array('option_name' => $key), $format);
    } else {
        $wpdb->insert($table_name, $data, $format);
    }
}

// Check local subscription status from database
function cum_check_local_subscription() {
    $subscription_status = cum_get_gpl_server_option('sub', 0);
    return (int)$subscription_status === 1;
}

// Check remote subscription status with caching
function cum_check_remote_subscription() {
    static $subscription_cache = null;
    
    if ($subscription_cache !== null) {
        return $subscription_cache;
    }

    $token = cum_get_gpl_server_option('token', '');
    $subscription_id = cum_get_gpl_server_option('ids', '');
    
    if (empty($token) || empty($subscription_id)) {
        error_log('Subscription check failed: Token or ID missing');
        $subscription_cache = array('status' => false, 'credits' => 0);
        return $subscription_cache;
    }

    $request_args = array(
        'method' => 'POST',
        'timeout' => 30,
        'sslverify' => false,
        'headers' => array(
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Accept' => 'application/json',
            'X-Client-Domain' => cum_get_normalized_domain() // أضف هذا السطر
        ),
        'body' => array(
            'token' => $token,
            'subscription_id' => $subscription_id
        )
    );

    $response = wp_remote_post(SUBSCRIPTION_CHECK_URL, $request_args);

    if (is_wp_error($response)) {
        error_log('Subscription check failed: ' . $response->get_error_message());
        $subscription_cache = array('status' => false, 'credits' => 0);
        return $subscription_cache;
    }

    $response_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);

    if ($response_code === 200) {
        $data = json_decode($response_body, true);
        
        if (json_last_error() !== JSON_ERROR_NONE) {
            error_log('Subscription check: JSON parse error');
            $subscription_cache = array('status' => false, 'credits' => 0);
            return $subscription_cache;
        }

        $subscription_status = isset($data['subscription']['status']) ? $data['subscription']['status'] : 'inactive';
        $credits = 0;

        if (isset($data['subscription']['meta_data'])) {
            foreach ($data['subscription']['meta_data'] as $meta) {
                if (isset($meta['_credits'])) {
                    $credits = (int)$meta['_credits'];
                    break;
                }
            }
        }

        $is_active = !in_array($subscription_status, array('suspended', 'cancelled', 'expired'));

        if ($is_active) {
            cum_update_gpl_server_option('sub', 1);
            cum_update_gpl_server_option('credits', $credits);
            
            error_log('Subscription is ACTIVE. Credits: ' . $credits);
            $subscription_cache = array('status' => true, 'credits' => $credits);
            return $subscription_cache;
        }
    }

    cum_update_gpl_server_option('sub', 0);
    cum_update_gpl_server_option('credits', 0);
    
    error_log('Subscription check failed');
    $subscription_cache = array('status' => false, 'credits' => 0);
    return $subscription_cache;
}

// Get selections from database
function cum_get_selections() {
    $selections = cum_get_gpl_server_option('pt_list', array());
    
    if (!is_array($selections) || !isset($selections['plugins']) || !isset($selections['themes'])) {
        return array('plugins' => array(), 'themes' => array());
    }
    
    return $selections;
}

// Get available updates from server
function cum_get_available_updates() {
    $updates_data = cum_fetch_updates_data();
    $available_updates = array(
        'plugins' => array(),
        'themes' => array()
    );
    
    if (!$updates_data) {
        return $available_updates;
    }
    
    // Get current versions
    $current_plugins = get_plugins();
    $current_themes = wp_get_themes();
    $selections = cum_get_selections();
    
    // Check plugins updates
    if (!empty($updates_data['plugins'])) {
        foreach ($updates_data['plugins'] as $plugin_slug => $plugin_info) {
            $plugin_file = $plugin_slug . '/' . $plugin_slug . '.php';
            
            // Check if plugin is selected for custom updates and exists locally
            if (in_array($plugin_file, $selections['plugins']) && isset($current_plugins[$plugin_file])) {
                $current_version = $current_plugins[$plugin_file]['Version'];
                $new_version = $plugin_info['version'];
                
                if (version_compare($current_version, $new_version, '<')) {
                    $available_updates['plugins'][$plugin_file] = array(
                        'current_version' => $current_version,
                        'new_version' => $new_version,
                        'name' => $current_plugins[$plugin_file]['Name']
                    );
                }
            }
        }
    }
    
    // Check themes updates
    if (!empty($updates_data['themes'])) {
        foreach ($updates_data['themes'] as $theme_slug => $theme_info) {
            // Check if theme is selected for custom updates and exists locally
            if (in_array($theme_slug, $selections['themes']) && isset($current_themes[$theme_slug])) {
                $current_version = $current_themes[$theme_slug]->get('Version');
                $new_version = $theme_info['version'];
                
                if (version_compare($current_version, $new_version, '<')) {
                    $available_updates['themes'][$theme_slug] = array(
                        'current_version' => $current_version,
                        'new_version' => $new_version,
                        'name' => $current_themes[$theme_slug]->get('Name')
                    );
                }
            }
        }
    }
    
    return $available_updates;
}

// Toggle item status via AJAX
function cum_toggle_item_status() {
    // Verify nonce
    if (!wp_verify_nonce($_POST['nonce'], 'cum_toggle_item_nonce')) {
        wp_die(__('Security check failed.', 'custom-updates-manager'));
    }

    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions.', 'custom-updates-manager'));
    }

    $item_type = sanitize_text_field($_POST['item_type']);
    $item_slug = sanitize_text_field($_POST['item_slug']);
    $action = sanitize_text_field($_POST['action_type']);

    $selections = cum_get_selections();
    
    if ($item_type === 'plugin') {
        if ($action === 'enable') {
            if (!in_array($item_slug, $selections['plugins'])) {
                $selections['plugins'][] = $item_slug;
            }
        } else {
            $selections['plugins'] = array_diff($selections['plugins'], array($item_slug));
        }
    } elseif ($item_type === 'theme') {
        if ($action === 'enable') {
            if (!in_array($item_slug, $selections['themes'])) {
                $selections['themes'][] = $item_slug;
            }
        } else {
            $selections['themes'] = array_diff($selections['themes'], array($item_slug));
        }
    }

    cum_update_gpl_server_option('pt_list', $selections);
    
    // Clear updates cache
    delete_transient('cum_updates_data');
    wp_clean_update_cache();
    
    wp_send_json_success(array(
        'message' => __('Status updated successfully.', 'custom-updates-manager'),
        'new_status' => $action === 'enable' ? 'enabled' : 'disabled'
    ));
}
add_action('wp_ajax_cum_toggle_item_status', 'cum_toggle_item_status');

// Force check for updates
function cum_force_check_updates() {
    wp_clean_update_cache();
    wp_update_plugins();
    wp_update_themes();
    
    $data = cum_fetch_updates_data(true);
    
    return $data;
}

// Handle cache clearing
add_action('admin_init', 'cum_handle_clear_cache_request');
function cum_handle_clear_cache_request() {
    if (isset($_GET['cum_clear_cache']) && $_GET['cum_clear_cache'] === '1') {
        if (!wp_verify_nonce($_GET['_wpnonce'], 'cum_clear_cache_nonce')) {
            wp_die(__('Security check failed.', 'custom-updates-manager'));
        }

        delete_transient('cum_updates_data');
        cum_force_check_updates();
        
        add_settings_error(
            'cum_messages',
            'cum_message',
            __('Updates cache cleared successfully. Checking for new updates...', 'custom-updates-manager'),
            'updated'
        );
        
        set_transient('settings_errors', get_settings_errors(), 30);
        wp_redirect(add_query_arg('settings-updated', 'true', remove_query_arg(array('cum_clear_cache', '_wpnonce'))));
        exit;
    }
}

// Fetch updates data from server
function cum_fetch_updates_data($force = false) {
    $cache_key = 'cum_updates_data';
    
    if (!$force) {
        $data = get_transient($cache_key);
        if (false !== $data) {
            return $data;
        }
    }
    
    $token = cum_get_gpl_server_option('token', '');
    $ids = cum_get_gpl_server_option('ids', '');
    
    if (empty($token)) {
        error_log('Cannot fetch updates - token is empty');
        return false;
    }
    
    $url = add_query_arg(['versions_only' => '1'], CUSTOM_UPDATES_SERVER);
    
    $response = wp_remote_get($url, [
        'timeout' => 10,
        'sslverify' => false,
        'headers' => [
            'X-Custom-Updates' => CUSTOM_UPDATES_HEADER,
            'X-Auth-Token' => $token,
            'X-Auth-ID' => $ids,
            'X-Client-Domain' => cum_get_normalized_domain() // أضف هذا السطر
        ],
    ]);

    if (is_wp_error($response)) {
        error_log('Error fetching updates: ' . $response->get_error_message());
        return false;
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log('JSON Error: ' . json_last_error_msg());
        return false;
    }

    set_transient($cache_key, $data, 12 * HOUR_IN_SECONDS);
    return $data;
}

// Render settings page
function cum_render_settings_page() {
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.'));
    }

    $has_subscription = cum_check_local_subscription();
    
    settings_errors('cum_messages');

    $selections = cum_get_selections();
    $selected_plugins = $selections['plugins'];
    $selected_themes = $selections['themes'];
    
    $plugins = get_plugins();
    $themes = wp_get_themes();
    
    // Get available updates
    $available_updates = cum_get_available_updates();
    
    ?>
    <style>
        .cum-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .cum-card {
            background: #fff;
            border: 1px solid #ccd0d4;
            box-shadow: 0 1px 1px rgba(0,0,0,0.04);
            margin-bottom: 20px;
        }
        .cum-card-header {
            border-bottom: 1px solid #dcdcde;
            padding: 12px 20px;
            background: #f6f7f7;
        }
        .cum-card-body {
            padding: 20px;
        }
        .cum-table {
            width: 100%;
            border-collapse: collapse;
        }
        .cum-table th {
            text-align: left;
            padding: 10px;
            background: #f6f7f7;
            border-bottom: 1px solid #dcdcde;
        }
        .cum-table td {
            padding: 10px;
            border-bottom: 1px solid #dcdcde;
            vertical-align: middle;
        }
        .cum-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .cum-table tr:hover {
            background-color: #f0f0f1;
        }
        .cum-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: 600;
            line-height: 1;
        }
        .cum-badge-primary {
            background: #d1e5f9;
            color: #135e96;
        }
        .cum-badge-secondary {
            background: #e0e0e0;
            color: #50575e;
        }
        .cum-badge-update {
            background: #f0f6fc;
            color: #2271b1;
            border: 1px solid #2271b1;
        }
        .cum-search-box {
            margin-bottom: 15px;
        }
        .cum-search-input {
            width: 300px;
            padding: 5px 10px;
        }
        .cum-disabled-form {
            pointer-events: none;
        }
        .cum-subscription-alert {
            background: #fff8e5;
            border-left: 4px solid #ffb900;
            padding: 12px;
            margin-bottom: 20px;
        }
        .cum-selected-item {
            background-color: #f0f9eb !important;
            order: -1;
        }
        .cum-status-toggle {
            cursor: pointer;
            padding: 5px 10px;
            border-radius: 3px;
            transition: all 0.3s ease;
        }
        .cum-status-toggle.enabled {
            background: #d1e7dd;
            color: #0f5132;
        }
        .cum-status-toggle.disabled {
            background: #f8d7da;
            color: #721c24;
        }
        .cum-status-toggle:hover {
            opacity: 0.8;
        }
        .cum-status-toggle.loading {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .cum-ajax-message {
            position: fixed;
            top: 50px;
            right: 20px;
            padding: 12px 20px;
            border-radius: 4px;
            z-index: 10000;
            display: none;
        }
        .cum-ajax-message.success {
            background: #d1e7dd;
            color: #0f5132;
            border: 1px solid #badbcc;
        }
        .cum-ajax-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .cum-update-button {
            background: #2271b1;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 3px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 12px;
            transition: background 0.3s ease;
        }
        .cum-update-button:hover {
            background: #135e96;
            color: white;
        }
        .cum-update-button:disabled {
            background: #a7aaad;
            cursor: not-allowed;
        }
        .cum-version-info {
            font-size: 12px;
            color: #666;
        }
        .cum-update-available {
            background: #f0f6fc !important;
            border-left: 3px solid #2271b1;
        }
        .cum-update-info {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }
        .cum-new-version {
            color: #d63638;
            font-weight: bold;
        }
        .cum-current-version {
            color: #007017;
        }
    </style>
    
    <div class="wrap cum-container">
        <h1><?php echo esc_html__('Custom Updates Manager', 'custom-updates-manager'); ?></h1>
        
        <div id="cum-ajax-message" class="cum-ajax-message"></div>
        
        <?php if (!$has_subscription): ?>
            <div class="cum-subscription-alert">
                <p><?php echo esc_html__('Your account is currently limited. Updates will be shown but the download will only complete if your subscription is active when you click "Update Now".', 'custom-updates-manager'); ?></p>
            </div>
        <?php endif; ?>
        
        <div class="cum-card">
            <div class="cum-card-header">
                <h2><?php echo esc_html__('Plugins Management', 'custom-updates-manager'); ?></h2>
                <p><?php echo sprintf(__('Available updates: %d', 'custom-updates-manager'), count($available_updates['plugins'])); ?></p>
            </div>
            <div class="cum-card-body">
                <div class="cum-search-box">
                    <input type="text" id="plugin-search" class="cum-search-input" placeholder="<?php esc_attr_e('Search plugins...', 'custom-updates-manager'); ?>">
                </div>
                <table class="cum-table">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Plugin Name', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Version', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Status', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Update', 'custom-updates-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody id="plugins-table-body">
                        <?php foreach ($plugins as $plugin_file => $plugin_data) :
                        $is_selected = in_array($plugin_file, $selected_plugins);
                        $row_class = $is_selected ? 'cum-selected-item' : '';
                        $has_update = isset($available_updates['plugins'][$plugin_file]);
                        if ($has_update) {
                            $row_class .= ' cum-update-available';
                        }
                        ?>
                        <tr class="plugin-row <?php echo esc_attr($row_class); ?>" data-item-type="plugin" data-item-slug="<?php echo esc_attr($plugin_file); ?>">
                            <td>
                                <strong><?php echo esc_html($plugin_data['Name']); ?></strong>
                                <div class="row-actions">
                                    <?php if ($is_selected) : ?>
                                        <span class="cum-badge cum-badge-primary"><?php esc_html_e('Custom Updates', 'custom-updates-manager'); ?></span>
                                    <?php else : ?>
                                        <span class="cum-badge cum-badge-secondary"><?php esc_html_e('WordPress Updates', 'custom-updates-manager'); ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="cum-update-info">
                                    <span class="cum-current-version"><?php echo esc_html($plugin_data['Version']); ?></span>
                                    <?php if ($has_update): ?>
                                        <span class="cum-new-version"><?php 
                                            echo sprintf(
                                                __('New: %s', 'custom-updates-manager'), 
                                                esc_html($available_updates['plugins'][$plugin_file]['new_version'])
                                            ); 
                                        ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php if ($has_subscription): ?>
                                    <span class="cum-status-toggle <?php echo $is_selected ? 'enabled' : 'disabled'; ?>" 
                                          data-current-status="<?php echo $is_selected ? 'enabled' : 'disabled'; ?>">
                                        <?php if ($is_selected): ?>
                                            ✓ <?php esc_html_e('Enabled', 'custom-updates-manager'); ?>
                                        <?php else: ?>
                                            ✗ <?php esc_html_e('Disabled', 'custom-updates-manager'); ?>
                                        <?php endif; ?>
                                    </span>
                                <?php else: ?>
                                    <?php if ($is_selected): ?>
                                        <span style="color: #00a32a;">✓ <?php esc_html_e('Enabled', 'custom-updates-manager'); ?></span>
                                    <?php else: ?>
                                        <span style="color: #d63638;">✗ <?php esc_html_e('Disabled', 'custom-updates-manager'); ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($has_update && $is_selected): ?>
                                    <?php
                                    $update_url = wp_nonce_url(
                                        add_query_arg([
                                            'action' => 'upgrade-plugin',
                                            'plugin' => $plugin_file
                                        ], self_admin_url('update.php')),
                                        'upgrade-plugin_' . $plugin_file
                                    );
                                    ?>
                                    <a href="<?php echo esc_url($update_url); ?>" class="cum-update-button">
                                        <?php esc_html_e('Update Now', 'custom-updates-manager'); ?>
                                    </a>
                                <?php elseif ($has_update && !$is_selected): ?>
                                    <span class="cum-badge cum-badge-update">
                                        <?php esc_html_e('Enable for updates', 'custom-updates-manager'); ?>
                                    </span>
                                <?php else: ?>
                                    <span style="color: #007017;"><?php esc_html_e('Up to date', 'custom-updates-manager'); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="cum-card">
            <div class="cum-card-header">
                <h2><?php echo esc_html__('Themes Management', 'custom-updates-manager'); ?></h2>
                <p><?php echo sprintf(__('Available updates: %d', 'custom-updates-manager'), count($available_updates['themes'])); ?></p>
            </div>
            <div class="cum-card-body">
                <div class="cum-search-box">
                    <input type="text" id="theme-search" class="cum-search-input" placeholder="<?php esc_attr_e('Search themes...', 'custom-updates-manager'); ?>">
                </div>
                <table class="cum-table">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Theme Name', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Version', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Status', 'custom-updates-manager'); ?></th>
                            <th><?php echo esc_html__('Update', 'custom-updates-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody id="themes-table-body">
                        <?php foreach ($themes as $theme_slug => $theme_data) : 
                        $is_selected = in_array($theme_slug, $selected_themes);
                        $row_class = $is_selected ? 'cum-selected-item' : '';
                        $has_update = isset($available_updates['themes'][$theme_slug]);
                        if ($has_update) {
                            $row_class .= ' cum-update-available';
                        }
                        ?>
                        <tr class="theme-row <?php echo esc_attr($row_class); ?>" data-item-type="theme" data-item-slug="<?php echo esc_attr($theme_slug); ?>">
                            <td>
                                <strong><?php echo esc_html($theme_data->get('Name')); ?></strong>
                                <div class="row-actions">
                                    <?php if ($is_selected) : ?>
                                        <span class="cum-badge cum-badge-primary"><?php esc_html_e('Custom Updates', 'custom-updates-manager'); ?></span>
                                    <?php else : ?>
                                        <span class="cum-badge cum-badge-secondary"><?php esc_html_e('WordPress Updates', 'custom-updates-manager'); ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="cum-update-info">
                                    <span class="cum-current-version"><?php echo esc_html($theme_data->get('Version')); ?></span>
                                    <?php if ($has_update): ?>
                                        <span class="cum-new-version"><?php 
                                            echo sprintf(
                                                __('New: %s', 'custom-updates-manager'), 
                                                esc_html($available_updates['themes'][$theme_slug]['new_version'])
                                            ); 
                                        ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php if ($has_subscription): ?>
                                    <span class="cum-status-toggle <?php echo $is_selected ? 'enabled' : 'disabled'; ?>" 
                                          data-current-status="<?php echo $is_selected ? 'enabled' : 'disabled'; ?>">
                                        <?php if ($is_selected): ?>
                                            ✓ <?php esc_html_e('Enabled', 'custom-updates-manager'); ?>
                                        <?php else: ?>
                                            ✗ <?php esc_html_e('Disabled', 'custom-updates-manager'); ?>
                                        <?php endif; ?>
                                    </span>
                                <?php else: ?>
                                    <?php if ($is_selected): ?>
                                        <span style="color: #00a32a;">✓ <?php esc_html_e('Enabled', 'custom-updates-manager'); ?></span>
                                    <?php else: ?>
                                        <span style="color: #d63638;">✗ <?php esc_html_e('Disabled', 'custom-updates-manager'); ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($has_update && $is_selected): ?>
                                    <?php
                                    $update_url = wp_nonce_url(
                                        add_query_arg([
                                            'action' => 'upgrade-theme',
                                            'theme' => $theme_slug
                                        ], self_admin_url('update.php')),
                                        'upgrade-theme_' . $theme_slug
                                    );
                                    ?>
                                    <a href="<?php echo esc_url($update_url); ?>" class="cum-update-button">
                                        <?php esc_html_e('Update Now', 'custom-updates-manager'); ?>
                                    </a>
                                <?php elseif ($has_update && !$is_selected): ?>
                                    <span class="cum-badge cum-badge-update">
                                        <?php esc_html_e('Enable for updates', 'custom-updates-manager'); ?>
                                    </span>
                                <?php else: ?>
                                    <span style="color: #007017;"><?php esc_html_e('Up to date', 'custom-updates-manager'); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
    jQuery(document).ready(function($) {
        var ajaxNonce = '<?php echo wp_create_nonce('cum_toggle_item_nonce'); ?>';
        
        // Search functionality
        $('#plugin-search').keyup(function() {
            var search = $(this).val().toLowerCase();
            $('.plugin-row').each(function() {
                var text = $(this).text().toLowerCase();
                $(this).toggle(text.indexOf(search) > -1);
            });
        });
        
        $('#theme-search').keyup(function() {
            var search = $(this).val().toLowerCase();
            $('.theme-row').each(function() {
                var text = $(this).text().toLowerCase();
                $(this).toggle(text.indexOf(search) > -1);
            });
        });
        
        // Toggle status functionality
        $('.cum-status-toggle').click(function() {
            var $toggle = $(this);
            var $row = $toggle.closest('tr');
            var itemType = $row.data('item-type');
            var itemSlug = $row.data('item-slug');
            var currentStatus = $toggle.data('current-status');
            var newStatus = currentStatus === 'enabled' ? 'disabled' : 'enabled';
            var actionType = newStatus === 'enabled' ? 'enable' : 'disable';
            
            // Prevent multiple clicks
            if ($toggle.hasClass('loading')) {
                return;
            }
            
            // Show loading state
            $toggle.addClass('loading');
            
            // Send AJAX request
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'cum_toggle_item_status',
                    nonce: ajaxNonce,
                    item_type: itemType,
                    item_slug: itemSlug,
                    action_type: actionType
                },
                success: function(response) {
                    if (response.success) {
                        // Update toggle appearance
                        $toggle.removeClass('enabled disabled').addClass(newStatus);
                        $toggle.data('current-status', newStatus);
                        
                        if (newStatus === 'enabled') {
                            $toggle.html('✓ <?php esc_html_e('Enabled', 'custom-updates-manager'); ?>');
                            $row.addClass('cum-selected-item');
                            $row.find('.cum-badge').removeClass('cum-badge-secondary').addClass('cum-badge-primary').text('<?php esc_html_e('Custom Updates', 'custom-updates-manager'); ?>');
                            
                            // Check if there's an update available and refresh the update column
                            if ($row.find('.cum-new-version').length > 0) {
                                location.reload(); // Reload to show update button
                            }
                        } else {
                            $toggle.html('✗ <?php esc_html_e('Disabled', 'custom-updates-manager'); ?>');
                            $row.removeClass('cum-selected-item');
                            $row.find('.cum-badge').removeClass('cum-badge-primary').addClass('cum-badge-secondary').text('<?php esc_html_e('WordPress Updates', 'custom-updates-manager'); ?>');
                            
                            // Refresh the update column
                            location.reload();
                        }
                        
                        // Show success message
                        showAjaxMessage(response.data.message, 'success');
                    } else {
                        showAjaxMessage('<?php esc_html_e('Error updating status.', 'custom-updates-manager'); ?>', 'error');
                    }
                },
                error: function() {
                    showAjaxMessage('<?php esc_html_e('Error updating status.', 'custom-updates-manager'); ?>', 'error');
                },
                complete: function() {
                    $toggle.removeClass('loading');
                }
            });
        });
        
        // Sort rows with selected items first and update available items first
        $('#plugins-table-body .plugin-row').sort(function(a, b) {
            var aSelected = $(a).hasClass('cum-selected-item') ? 2 : 0;
            var aUpdate = $(a).hasClass('cum-update-available') ? 1 : 0;
            var bSelected = $(b).hasClass('cum-selected-item') ? 2 : 0;
            var bUpdate = $(b).hasClass('cum-update-available') ? 1 : 0;
            
            return (bSelected + bUpdate) - (aSelected + aUpdate);
        }).appendTo('#plugins-table-body');
        
        $('#themes-table-body .theme-row').sort(function(a, b) {
            var aSelected = $(a).hasClass('cum-selected-item') ? 2 : 0;
            var aUpdate = $(a).hasClass('cum-update-available') ? 1 : 0;
            var bSelected = $(b).hasClass('cum-selected-item') ? 2 : 0;
            var bUpdate = $(b).hasClass('cum-update-available') ? 1 : 0;
            
            return (bSelected + bUpdate) - (aSelected + aUpdate);
        }).appendTo('#themes-table-body');
        
        // Function to show AJAX messages
        function showAjaxMessage(message, type) {
            var $message = $('#cum-ajax-message');
            $message.removeClass('success error').addClass(type).text(message).fadeIn();
            
            setTimeout(function() {
                $message.fadeOut();
            }, 3000);
        }
    });
    </script>
    <?php
}

// Hide official updates for selected items
add_filter('site_transient_update_plugins', 'cum_hide_official_updates');
function cum_hide_official_updates($transient) {
    if (!is_object($transient) || !isset($transient->response)) {
        return $transient;
    }

    $selections = cum_get_selections();
    foreach ($selections['plugins'] as $plugin_file) {
        if (isset($transient->response[$plugin_file])) {
            unset($transient->response[$plugin_file]);
        }
    }
    
    return $transient;
}

add_filter('site_transient_update_themes', 'cum_hide_official_themes_updates');
function cum_hide_official_themes_updates($transient) {
    if (!is_object($transient) || !isset($transient->response)) {
        return $transient;
    }

    $selections = cum_get_selections();
    foreach ($selections['themes'] as $theme_slug) {
        if (isset($transient->response[$theme_slug])) {
            unset($transient->response[$theme_slug]);
        }
    }
    
    return $transient;
}

// Check for custom updates
add_filter('site_transient_update_plugins', 'cum_check_plugins_updates');
function cum_check_plugins_updates($transient) {
    $data = cum_fetch_updates_data();
    if (!$data || empty($data['plugins'])) return $transient;

    $selections = cum_get_selections();
    $selected_plugins = $selections['plugins'];

    foreach ($data['plugins'] as $plugin_slug => $plugin_info) {
        $plugin_file = $plugin_slug . '/' . $plugin_slug . '.php';
        
        if (in_array($plugin_file, $selected_plugins) && isset($transient->checked[$plugin_file])) {
            if (version_compare($transient->checked[$plugin_file], $plugin_info['version'], '<')) {
                // إنشاء كائن التحديث مع جميع الخصائص المطلوبة
                $update = new stdClass();
                $update->id = $plugin_file;
                $update->slug = $plugin_slug;
                $update->plugin = $plugin_file; // هذه الخاصية مهمة جداً
                $update->new_version = $plugin_info['version'];
                $update->package = 'custom-update-request:' . $plugin_file;
                $update->url = isset($plugin_info['url']) ? $plugin_info['url'] : '';
                $update->cum_custom_update = true;
                
                $transient->response[$plugin_file] = $update;
            }
        }
    }

    return $transient;
}

add_filter('site_transient_update_themes', 'cum_check_themes_updates');
function cum_check_themes_updates($transient) {
    $data = cum_fetch_updates_data();
    if (!$data || empty($data['themes'])) return $transient;

    $selections = cum_get_selections();
    $selected_themes = $selections['themes'];

    foreach ($data['themes'] as $theme_slug => $theme_info) {
        if (in_array($theme_slug, $selected_themes) && isset($transient->checked[$theme_slug])) {
            if (version_compare($transient->checked[$theme_slug], $theme_info['version'], '<')) {
                $transient->response[$theme_slug] = array(
                    'theme' => $theme_slug,
                    'new_version' => $theme_info['version'],
                    'package' => 'custom-update-request:' . $theme_slug,
                    'url' => isset($theme_info['url']) ? $theme_info['url'] : '', // تأكد من وجود حقل url
                    'cum_custom_update' => true
                );
            }
        }
    }

    return $transient;
}

// Verify subscription before update
add_filter('upgrader_package_options', 'cum_verify_subscription_before_update');
function cum_verify_subscription_before_update($options) {
    if (!isset($options['package']) || strpos($options['package'], 'custom-update-request:') !== 0) {
        return $options;
    }

    $subscription_info = cum_check_remote_subscription();
    
    if (!$subscription_info['status']) {
        return new WP_Error('subscription_expired', 
            __('Your subscription has expired or is not active. Please renew your subscription to receive updates.', 'custom-updates-manager'));
    }
    
    if ($subscription_info['credits'] <= 0) {
        return new WP_Error('no_credits', 
            __('Your credits balance is zero. Please purchase more credits to receive updates.', 'custom-updates-manager'));
    }
    
    return $options;
}

// Modify HTTP request args
add_filter('http_request_args', 'cum_modify_http_request_args', 10, 2);
function cum_modify_http_request_args($args, $url) {
    if (strpos($url, 'cdn.gplcenter.com') !== false) {
        $args['sslverify'] = false;
        $args['reject_unsafe_urls'] = false;
    }
    return $args;
}

// Provide download URL when requested
add_filter('upgrader_pre_download', 'cum_provide_download_url', 10, 3);
function cum_provide_download_url($reply, $package, $upgrader) {
    if (strpos($package, 'custom-update-request:') !== 0) {
        return $reply;
    }

    $item = explode(':', $package)[1];
    $is_plugin = (strpos($item, '.php') !== false);
    $item_slug = $is_plugin ? dirname($item) : $item;
    
    $token = cum_get_gpl_server_option('token', '');
    $ids = cum_get_gpl_server_option('ids', '');
    
    error_log("[CUM] Requesting download URL for: {$item_slug} (Type: " . ($is_plugin ? 'plugin' : 'theme') . ")");

    $response = wp_remote_post(CUSTOM_UPDATES_SERVER, [
        'timeout' => 30,
        'sslverify' => false,
        'headers' => [
            'X-Custom-Updates' => CUSTOM_UPDATES_HEADER,
            'X-Auth-Token' => $token,
            'X-Auth-ID' => $ids,
            'X-Request-Type' => 'get_download_link',
            'X-Item-Slug' => $item_slug,
            'X-Item-Type' => $is_plugin ? 'plugin' : 'theme',
            'X-Client-Domain' => cum_get_normalized_domain()
        ]
    ]);

    if (is_wp_error($response)) {
        error_log('[CUM] Failed to fetch download URL: ' . $response->get_error_message());
        return new WP_Error('download_failed', 'Failed to fetch download URL: ' . $response->get_error_message());
    }

    $response_body = wp_remote_retrieve_body($response);
    $data = json_decode($response_body, true);
    
    if (empty($data['download_url'])) {
        error_log('[CUM] Empty download URL in response: ' . print_r($data, true));
        return new WP_Error('no_url', 'Download URL not found in server response.');
    }

    error_log(sprintf(
        '[CUM] Download URL Received - Item: %s | URL: %s | Size: %s',
        $item_slug,
        $data['download_url'],
        isset($data['size']) ? size_format($data['size']) : 'N/A'
    ));

    $tmp_file = download_url($data['download_url']);
    
    if (is_wp_error($tmp_file)) {
        error_log('[CUM] Download failed: ' . $tmp_file->get_error_message());
        return new WP_Error('download_failed', 'Failed to download package: ' . $tmp_file->get_error_message());
    }

    $backup_dir = WP_CONTENT_DIR . '/cum-updates-backups/';
    if (!file_exists($backup_dir)) {
        wp_mkdir_p($backup_dir);
    }
    
    $clean_filename = cum_extract_filename_from_url($data['download_url']) ?: $item_slug . '-' . time() . '.zip';
    $backup_path = $backup_dir . $clean_filename;
    
    if (copy($tmp_file, $backup_path)) {
        error_log("[CUM] Backup saved successfully: {$backup_path}");
    } else {
        error_log("[CUM] Failed to save backup to: {$backup_path}");
    }

    return $tmp_file;
}

// Helper function to extract filename from URL
function cum_extract_filename_from_url($url) {
    $parsed = parse_url($url);
    if (!isset($parsed['path'])) return null;
    
    $filename = basename($parsed['path']);
    return sanitize_file_name(strtok($filename, '?'));
}

// Add admin bar button
add_action('admin_bar_menu', 'cum_add_admin_bar_button', 100);
function cum_add_admin_bar_button($admin_bar) {
    if (!current_user_can('manage_options')) return;

    $admin_bar->add_node(array(
        'id'    => 'cum-clear-cache',
        'title' => __('Clear Updates Cache', 'custom-updates-manager'),
        'href'  => wp_nonce_url(admin_url('?cum_clear_cache=1'), 'cum_clear_cache_nonce'),
    ));
}

// Detect plugins with custom updates
add_action('activated_plugin', 'cum_detect_custom_updates_plugins_on_activation');
function cum_detect_custom_updates_plugins_on_activation($plugin_file) {
    $plugin_path = WP_PLUGIN_DIR . '/' . $plugin_file;
    if (!file_exists($plugin_path)) return;

    $plugin_content = file_get_contents($plugin_path);
    $has_custom_update = (strpos($plugin_content, 'Custom Updates: true') !== false);

    $selections = cum_get_selections();
    $selected_plugins = $selections['plugins'];

    if ($has_custom_update && !in_array($plugin_file, $selected_plugins)) {
        $selected_plugins[] = $plugin_file;
    } elseif (!$has_custom_update && in_array($plugin_file, $selected_plugins)) {
        $selected_plugins = array_diff($selected_plugins, array($plugin_file));
    }

    $selections['plugins'] = $selected_plugins;
    cum_update_gpl_server_option('pt_list', $selections);
}

// Detect themes with custom updates
add_action('switch_theme', 'cum_detect_custom_updates_themes_on_activation');
function cum_detect_custom_updates_themes_on_activation() {
    $current_theme = wp_get_theme();
    $theme_path = $current_theme->get_stylesheet_directory() . '/style.css';
    
    if (!file_exists($theme_path)) return;

    $theme_content = file_get_contents($theme_path);
    $has_custom_update = (strpos($theme_content, 'Custom Updates: true') !== false);

    $selections = cum_get_selections();
    $selected_themes = $selections['themes'];

    if ($has_custom_update && !in_array($current_theme->get_stylesheet(), $selected_themes)) {
        $selected_themes[] = $current_theme->get_stylesheet();
    } elseif (!$has_custom_update && in_array($current_theme->get_stylesheet(), $selected_themes)) {
        $selected_themes = array_diff($selected_themes, array($current_theme->get_stylesheet()));
    }

    $selections['themes'] = $selected_themes;
    cum_update_gpl_server_option('pt_list', $selections);
}

// Load text domain for translations
add_action('plugins_loaded', 'cum_load_textdomain');
function cum_load_textdomain() {
    load_plugin_textdomain('custom-updates-manager', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}

// Migration function (run once on activation)
register_activation_hook(__FILE__, 'cum_migrate_to_database');
function cum_migrate_to_database() {
    $current = cum_get_gpl_server_option('pt_list', false);
    
    if ($current === false) {
        cum_update_gpl_server_option('pt_list', array(
            'plugins' => array(),
            'themes' => array()
        ));
    }
}