jQuery(document).ready(function($) {
    // دالة لعرض الإشعارات
    function showNotification(message, type) {
        // إنشاء عنصر الإشعار
        var notification = $('<div class="notification ' + type + '">' + message + '</div>');

        // إضافة الإشعار إلى body
        $('body').append(notification);

        // إظهار الإشعار
        setTimeout(function() {
            notification.addClass('show');
        }, 100);

        // إخفاء الإشعار بعد 3 ثوانٍ
        setTimeout(function() {
            notification.removeClass('show');
            setTimeout(function() {
                notification.remove();
                // تحديث الصفحة بعد اختفاء الإشعار
                location.reload();
            }, 500); // الانتظار 0.5 ثانية قبل إزالة العنصر
        }, 3000); // الإشعار يظهر لمدة 3 ثوانٍ
    }

    // التحقق من وجود رسائل إشعار في الصفحة
    if ($('.notification-message').length > 0) {
        var message = $('.notification-message').text();
        var type = $('.notification-message').data('type');

        // عرض الإشعار المؤقت
        showNotification(message, type);

        // إزالة الإشعار الثابت من الصفحة بعد عرضه
        $('.notification-message').remove();
    }
});


